ORCA/M Asm65816 2.1.0

0001 4CFC                       title 'QD Clipping          GS ROM 2.0'
0002 4CFC              ****************************************************************
0003 4CFC              *                                                              *
0004 4CFC              *              CLIPPING                                        *
0005 4CFC              *                                                              *
0006 4CFC              ****************************************************************
0007 4CFC
0008 4CFC
0009 4CFC              ****************************************************************
0010 4CFC              *                                                              *
0011 4CFC              *                   Copyright (C) 1985-1987                    *
0012 4CFC              *                   All Rights Reserved                        *
0013 4CFC              *                   Apple Computer, Inc.                       *
0014 4CFC              *                                                              *
0015 4CFC              ****************************************************************
0016 4CFC
0017 4CFC
0018 4CFC                       include 'all.macros' 
0019 4CFC                       include ':QDEquates:qd.data.asm' 
0020 4CFC
0021 4CFC
0022 4CFC                       INCLUDE ':QDEquates:core.globals1' 
0023 4CFC                       INCLUDE ':QDEquates:core.globals2' 
0024 4CFC                       INCLUDE ':QDEquates:region.equs' 
0025 4CFC                       INCLUDE ':QDEquates:rect.equs' 
0026 4CFC
0027 4CFC
0028 4CFC
0029 4CFC              ;-----------------------------------------------
0030 4CFC              ;
0031 4CFC              ;   Forward addresses and entries
0032 4CFC              ;
0033 4CFC              ;-----------------------------------------------
0034 4CFC
0035 4CFC                       ENTRY Y1ToMinRect 
0036 4CFC
0037 4CFC
0038 4CFC              ;                COPY CLIPPING/CLIPPING
0039 4CFC              ****************************************************************
0040 4CFC              *
0041 4CFC              * MakeMinRect
0042 4CFC              *
0043 4CFC              * Takes the contents of MinRect and intersects it with the
0044 4CFC              * following:
0045 4CFC              *                 BoundsRect
0046 4CFC              *                 PortRect
0047 4CFC              *                 ClipRgn Bounds Rect
0048 4CFC              *                 VisRgn Bounds Rect
0049 4CFC              *
0050 4CFC              * The resulting rectangle is left in MinRect.
0051 4CFC              *
0052 4CFC              * Carry returns
0053 4CFC              *      SET if result is null
0054 4CFC              *      CLEAR if result is valid rectangle
0055 4CFC              *
0056 4CFC              * The ClipRgn and VisRgn must already be dereferenced and
0057 4CFC              * locked with pointers in RgnPtrA and RgnPtrB.
0058 4CFC              *
0059 4CFC              ****************************************************************
0060 4CFC                       EXPORT iBMakeMinRect
0061 4CFC              iBMakeMinRect PROC 
0062 4CFC 20 99 4D              jsr   Y1ToMinRect
0063 4CFF                       ENDP 
0064 4CFF
0065 4CFF                       EXPORT iMakeMinRect
0066 4CFF              iMakeMinRect PROC 
0067 4CFF              *              using CoreData
0068 4CFF
0069 4CFF A5 00                 lda   MinRect                  ; start with whats there
0070 4D01 A0 02 00              ldy   #2                       ; region offset is 2 for top of bounds
0071 4D04 C5 1C                 cmp   PortRect
0072 4D06 10 02                 bpl   TopOK1
0073 4D08 A5 1C                 lda   PortRect
0074 4D0A C5 14        TopOk1   cmp   BoundsRect
0075 4D0C 10 02                 bpl   TopOk2
0076 4D0E A5 14                 lda   BoundsRect
0077 4D10 D7 54        TopOk2   cmp   [RgnPtrA],y
0078 4D12 10 02                 bpl   TopOk3
0079 4D14 B7 54                 lda   [RgnPtrA],y
0080 4D16 D7 64        TopOk3   cmp   [RgnPtrB],y
0081 4D18 10 02                 bpl   TopOk4
0082 4D1A B7 64                 lda   [RgnPtrB],y
0083 4D1C 85 00        TopOk4   sta   MinRect                  ; put result back in MinRect
0084 4D1E
0085 4D1E A5 02                 lda   MinRect+2
0086 4D20 C8                    iny   
0087 4D21 C8                    iny   
0088 4D22 C5 1E                 cmp   PortRect+2
0089 4D24 10 02                 bpl   LeftOk1
0090 4D26 A5 1E                 lda   PortRect+2
0091 4D28 C5 16        LeftOk1  cmp   BoundsRect+2
0092 4D2A 10 02                 bpl   LeftOk2
0093 4D2C A5 16                 lda   BoundsRect+2
0094 4D2E D7 54        LeftOk2  cmp   [RgnPtrA],y
0095 4D30 10 02                 bpl   LeftOk3
0096 4D32 B7 54                 lda   [RgnPtrA],y
0097 4D34 D7 64        LeftOk3  cmp   [RgnPtrB],y
0098 4D36 10 02                 bpl   LeftOk4
0099 4D38 B7 64                 lda   [RgnPtrB],y
0100 4D3A 85 02        LeftOk4  sta   MinRect+2
0101 4D3C
0102 4D3C
0103 4D3C A5 04                 lda   MinRect+4
0104 4D3E C8                    iny   
0105 4D3F C8                    iny   
0106 4D40 C5 20                 cmp   PortRect+4
0107 4D42 30 02                 bmi   BottomOk1
0108 4D44 A5 20                 lda   PortRect+4
0109 4D46 C5 18        BottomOk1 cmp   BoundsRect+4
0110 4D48 30 02                 bmi   BottomOk2
0111 4D4A A5 18                 lda   BoundsRect+4
0112 4D4C D7 54        BottomOk2 cmp   [RgnPtrA],y
0113 4D4E 30 02                 bmi   BottomOk3
0114 4D50 B7 54                 lda   [RgnPtrA],y
0115 4D52 D7 64        BottomOk3 cmp   [RgnPtrB],y
0116 4D54 30 02                 bmi   BottomOk4
0117 4D56 B7 64                 lda   [RgnPtrB],y
0118 4D58 85 04        BottomOk4 sta   MinRect+4
0119 4D5A
0120 4D5A A5 06                 lda   MinRect+6
0121 4D5C C8                    iny   
0122 4D5D C8                    iny   
0123 4D5E C5 22                 cmp   PortRect+6
0124 4D60 30 02                 bmi   RightOk1
0125 4D62 A5 22                 lda   PortRect+6
0126 4D64 C5 1A        RightOk1 cmp   BoundsRect+6
0127 4D66 30 02                 bmi   RightOk2
0128 4D68 A5 1A                 lda   BoundsRect+6
0129 4D6A D7 54        RightOk2 cmp   [RgnPtrA],y
0130 4D6C 30 02                 bmi   RightOk3
0131 4D6E B7 54                 lda   [RgnPtrA],y
0132 4D70 D7 64        RightOk3 cmp   [RgnPtrB],y
0133 4D72 30 02                 bmi   RightOk4
0134 4D74 B7 64                 lda   [RgnPtrB],y
0135 4D76 85 06        RightOk4 sta   MinRect+6
0136 4D78
0137 4D78
0138 4D78 A5 00                 lda   MinRect
0139 4D7A C5 04                 cmp   MinRect+4
0140 4D7C 10 08                 bpl   NullRect
0141 4D7E
0142 4D7E A5 02                 lda   MinRect+2
0143 4D80 C5 06                 cmp   MinRect+6
0144 4D82 10 02                 bpl   NullRect
0145 4D84
0146 4D84 18                    clc   
0147 4D85 6B           FinishIt rtl   
0148 4D86
0149 4D86 38           NullRect sec   
0150 4D87 6B                    rtl   
0151 4D88
0152 4D88
0153 4D88                       ENDP 
0154 4D88
0155 4D88
0156 4D88
0157 4D88                       EXPORT MinRectToY1 
0158 4D88              MinRectToY1 PROC 
0159 4D88
0160 4D88 A5 00                 lda   MinRect
0161 4D8A 85 A6                 sta   Y1
0162 4D8C A5 02                 lda   MinRect+2
0163 4D8E 85 A8                 sta   Y1+2
0164 4D90 A5 04                 lda   MinRect+4
0165 4D92 85 AA                 sta   Y1+4
0166 4D94 A5 06                 lda   MinRect+6
0167 4D96 85 AC                 sta   Y1+6
0168 4D98 60                    rts   
0169 4D99
0170 4D99                       ENDP 
0171 4D99
0172 4D99
0173 4D99
0174 4D99
0175 4D99                       EXPORT Y1ToMinRect 
0176 4D99              Y1ToMinRect PROC 
0177 4D99
0178 4D99 A5 A6                 lda   Y1
0179 4D9B 85 00                 sta   MinRect
0180 4D9D A5 A8                 lda   Y1+2
0181 4D9F 85 02                 sta   MinRect+2
0182 4DA1 A5 AA                 lda   Y1+4
0183 4DA3 85 04                 sta   MinRect+4
0184 4DA5 A5 AC                 lda   Y1+6
0185 4DA7 85 06                 sta   MinRect+6
0186 4DA9 60                    rts   
0187 4DAA
0188 4DAA                       ENDP 
0189 4DAA
0190 4DAA                       END   
